/// Section Begin  - CCSSP DHTM 2 (JavaScript 1.2)
// eHelp Corporation Dynamic HTML JavaScript 
// Copyright 1998-2000 eHelp Corporation.All rights reserved.
// Version=4.45

// Warning:Do not modify this file.It is generated by RoboHELP and changes will be overwritten.



//Begin the definition of CAgencyXXXX classes

//Begin of the CAgencyShow definition
function CAgencyShow( element, bIsShow )
{
	this.ele = element;
	this.bIsShow = bIsShow;
}

CAgencyShow.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject( this.ele, !this.bIsShow );
}

CAgencyShow.prototype.UpdateEffect = function()
{
	CCSSP.ShowObject( this.ele, this.bIsShow );
}

CAgencyShow.prototype.EndEffect = function()
{
	CCSSP.ShowObject( this.ele, !this.bIsShow );
}
// End of the CAgencyShow definition

// Begin of CAgencyFly definition
function CAgencyFly( element, settings, bIsIn )
{
	this.ele = element;
	this.bIsIn = bIsIn;
	this.duration = 1000; // default
	this.direction = "right";

	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		case "direction" : this.direction = arrOneSet[1]; break;
		}
	}
		
	if( CCSSP.bIsIE5 && this.ele.style.position != "absolute" )
		this.ele.style.position = "relative";
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyFly.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, !this.bIsIn );
}

CAgencyFly.prototype.UpdateEffect = function()
{
	if( this.timer == null )
		this.ResetParameters();

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else
	{
		var newX = this.startX*(1.0-percent) +  this.finalX*percent;
		var newY = this.startY*(1.0-percent) +  this.finalY*percent;
		CCSSP.MoveObjectTo(this.ele, newX, newY);
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencyFly.prototype.EndEffect = function()
{
	clearInterval( this.timer );
	this.timer = null;

	if( this.bIsIn ) // FlyIn
		CCSSP.MoveObjectTo(this.ele, this.finalX, this.finalY);
	else // FlyOut
		CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	CCSSP.ShowObject(this.ele, this.bIsIn );
}

CAgencyFly.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	CCSSP.ShowObject(this.ele, true );

	this.startX = 0;
	this.startY = 0;
	this.finalX = 0;
	this.finalY = 0; 
	
	var offsetLeft = CCSSP.GetObjectWindowLeft(this.ele) + this.ele.offsetWidth;
	var offsetTop = CCSSP.GetObjectWindowTop(this.ele) + this.ele.offsetHeight;
	var offsetRight = CCSSP.GetWindowRight();
	var offsetBottom = CCSSP.GetWindowBottom();

	if( this.bIsIn )
	{ // FlyIn
		this.finalX = this.ele.ABSX;
		this.finalY = this.ele.ABSY;

		switch( this.direction )
		{
		case "right": this.startX = offsetRight; this.startY = this.finalY; break;
		case "left": this.startX = -offsetLeft;  this.startY = this.finalY; break;
		case "down": this.startY = offsetBottom; this.startX = this.finalX; break;
		case "up":  this.startY = -offsetTop;    this.startX = this.finalX; break;
		case "downright":
  			this.startX = ( offsetBottom < offsetRight) ? offsetBottom : offsetRight;
			this.startY = this.startX;		break;
		case "upright":
  			this.startX = (offsetTop < offsetRight)? offsetTop : offsetRight;
			this.startY = -this.startX;		break;
		case "upleft":
			this.startX = -((offsetTop < offsetRight)? offsetTop : offsetRight);
			this.startY = this.startX;		break;
		case "downleft":
			this.startX = -(( offsetBottom < offsetRight) ? offsetBottom : offsetRight);
			this.startY = -this.startX;     break;
		}
	}
	else
	{ // FlyOut
		this.startX = this.ele.ABSX;
		this.startY = this.ele.ABSY;

		switch( this.direction )
		{
		case "right": this.finalX = offsetRight;  this.finalY = this.startY; break;
		case "left": this.finalX = -offsetLeft;   this.finalY = this.startY;  break;
		case "down": this.finalY = offsetBottom;  this.finalX = this.startX; break;
		case "up":  this.finalY = -offsetTop;     this.finalX = this.startX; break;
		case "downright":
  			this.finalX = ( offsetBottom < offsetRight) ? offsetBottom : offsetRight;
			this.finalY = this.finalX;		break;
		case "upright":
  			this.finalX = (offsetTop < offsetRight)? offsetTop : offsetRight;
			this.finalY = -this.finalX;		break;
		case "upleft":
			this.finalX = -((offsetTop < offsetRight)? offsetTop : offsetRight);
			this.finalY = this.finalX;		break;
		case "downleft":
			this.finalX = -(( offsetBottom < offsetRight) ? offsetBottom : offsetRight);
			this.finalY = -this.finalX;     break;
		}
	}
	CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	this.startTime = (new Date()).getTime();
}
// End of the CAgencyFly definition

// Begin of CAgencySpiral
function CAgencySpiral( element, settings, bIsIn )
{
	this.ele = element;
	this.bIsIn = bIsIn;
	this.duration = 1000; // default

	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		}
	}

	if( CCSSP.bIsIE5 && this.ele.style.position != "absolute" )
		this.ele.style.position = "relative";
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencySpiral.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, !this.bIsIn );
}

CAgencySpiral.prototype.UpdateEffect = function()
{
	if( this.timer == null )
		this.ResetParameters();

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else
	{
		var rf = (this.bIsIn)? (1.0 - percent) : percent; 
		var t = (1.0-rf) * 4.0 * Math.PI
		var rxP = (this.bIsIn)? this.startX : this.finalX; 
		var ryP = (this.bIsIn)? this.startY : this.finalY; 
		var rx = (Math.abs(rxP) < 200) ? Math.abs(rxP) : 200;
		var ry = (Math.abs(ryP) < 200) ? Math.abs(ryP) : 200;

		var newX = Math.ceil(-rf*Math.cos(t)*rx) + this.ele.ABSX;
		var newY = Math.ceil(-rf*Math.sin(t)*ry) + this.ele.ABSY;
		CCSSP.MoveObjectTo(this.ele, newX, newY);
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencySpiral.prototype.EndEffect = function()
{
	clearInterval( this.timer );
	this.timer = null;
	
	if( this.bIsIn ) // In
		CCSSP.MoveObjectTo(this.ele, this.finalX, this.finalY);
	else // Out
		CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	CCSSP.ShowObject(this.ele, this.bIsIn );
}

CAgencySpiral.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	CCSSP.ShowObject(this.ele, true );
	this.startX = (this.bIsIn)? CCSSP.GetWindowRight() : this.ele.ABSX;
	this.startY = (this.bIsIn)? CCSSP.GetWindowBottom() : this.ele.ABSY;
	this.finalX = (this.bIsIn)? this.ele.ABSX : CCSSP.GetWindowRight();
	this.finalY = (this.bIsIn)? this.ele.ABSY : CCSSP.GetWindowBottom(); 
	
	CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	this.startTime = (new Date()).getTime();
}
// End of CAgencySpiral

// Begin of CAgencyElastic
function CAgencyElastic( element, settings)
{
	this.ele = element;
	this.duration = 1000; // default
	this.direction = "right";

	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		case "direction" : this.direction = arrOneSet[1]; break;
		}
	}
		
	if( CCSSP.bIsIE5 && this.ele.style.position != "absolute" )
		this.ele.style.position = "relative";
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyElastic.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, false );
}

CAgencyElastic.prototype.UpdateEffect = function()
{
	if( this.timer == null )
		this.ResetParameters();

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else
	{
		var newX = this.startX;
		var newY = this.startY;
		var rf = Math.exp(-percent*3);
		var t = percent * 1.5 * Math.PI
		var rx = (Math.abs(this.startX) > Math.abs(this.startY)) ? this.startX : this.startY;
		switch (this.direction )
		{
		case "left":   
		case "right" : newX = rf*Math.cos(t)*rx + this.ele.ABSX; break;
		case "up":	   
		case "down" :  newY = rf*Math.cos(t)*rx + this.ele.ABSX; break;
		}
		CCSSP.MoveObjectTo(this.ele, newX, newY);
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencyElastic.prototype.EndEffect = function()
{
	CCSSP.MoveObjectTo(this.ele, this.finalX, this.finalY);
	clearInterval( this.timer );
	this.timer = null;
}

CAgencyElastic.prototype.ResetParameters = function()
{
	CCSSP.ShowObject(this.ele, true );
	this.startX = this.ele.ABSX;
	this.finalX = this.ele.ABSX;
	this.startY = this.ele.ABSY;
	this.finalY = this.ele.ABSY;
	
	switch (this.direction)
	{ 
	case "left":  this.startX = -this.ele.offsetWidth; break;
	case "right": this.startX = this.ele.offsetWidth;  break;
	case "up":    this.startY = -this.ele.offsetHeight;break;
	case "down":  this.startY = this.ele.offsetHeight; break;
	}
	CCSSP.MoveObjectTo(this.ele, this.startX, this.startY);
	this.startTime = (new Date()).getTime();
}
// End of CAgencyElastic

// Begin of CAgencyZoom
function CAgencyZoom( element, settings, bIsIn)
{
	this.ele = element;
	this.duration = 1000; // default
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		}
	}

	this.bIsIn = bIsIn;
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyZoom.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, false);
}

CAgencyZoom.prototype.UpdateEffect = function()
{
	if( this.timer == null )
		this.ResetParameters();

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else
	{
		var nFactorIn = Math.ceil(50+50*percent);
		var nFactorOut = Math.ceil(100+200*(1-percent));
		var AlterFontsize = ((this.bIsIn)? nFactorIn : nFactorOut) + "%";
		var AlterFactor = ((this.bIsIn)? nFactorIn : nFactorOut) / 100;
		
		this.UpdateEffectAllChildren(this.ele, AlterFontsize, AlterFactor);
		for(var index = 0; index < this.ele.all.length; index++)
			this.UpdateEffectAllChildren(this.ele.all[index], AlterFontsize, AlterFactor);
			
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencyZoom.prototype.UpdateEffectAllChildren = function(child, FontSize, Factor)
{
	if( CCSSP.IsTextTag(child) )
		child.style.fontSize = FontSize;
	else
	{
		if( typeof(child.orgWidth) == "number" )
			child.style.width = Factor * child.orgWidth;
		if( typeof(child.orgHeight) == "number" )
			child.style.height = Factor * child.orgHeight;
	}
}

CAgencyZoom.prototype.EndEffect = function()
{
	this.EndEffectAllChildren(this.ele);
	for(var index = 0; index < this.ele.all.length; index++)
		this.EndEffectAllChildren(this.ele.all[index]);
	
	clearInterval( this.timer );
	this.timer = null;
}

CAgencyZoom.prototype.EndEffectAllChildren = function( child )
{	
	if( CCSSP.IsTextTag(child) )
		child.style.fontSize = child.orgFontSize;
	else
	{
		if( typeof(child.intactWidth) != "undefined" )
		{
			child.width = child.intactWidth;
			child.height = child.intactHeight;
		}
		else if( typeof(child.style.intactPixelWidth) != "undefined" )
		{
			child.style.pixelWidth = child.style.intactPixelWidth;
			child.style.pixelHeight = child.style.intactPixelHeight;
		}
	}
}

CAgencyZoom.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	this.ResetParametersAllChildren( this.ele );
	for(var index = 0; index < this.ele.all.length; index++)
		this.ResetParametersAllChildren(this.ele.all[index]);
		
	this.startTime = (new Date()).getTime();
}

CAgencyZoom.prototype.ResetParametersAllChildren = function( child )
{
	CCSSP.ShowObject(child, true );
	if( (child.tagName == "DIV") && (child.parentElement.tagName == "TD") )
		child.width = "100%";// if the div is inside a cell of table, we need the this hack
	
	if( CCSSP.IsTextTag(child) )
		child.orgFontSize = child.style.fontSize;
	else
	{
		if( child.width > "" || child.height > "" )
		{
			child.orgWidth = child.intactWidth = child.width;
			child.orgHeight = child.intactHeight = child.height;
		}
		else if( ( typeof(child.orgWidth) != "number" ) && (typeof(child.orgHeight) != "number") )
		{
			child.orgWidth = child.style.intactPixelWidth = child.style.pixelWidth;
			child.orgHeight = child.style.intactPixelHeight = child.style.pixelHeight;
		}
	}
}
// End of CAgencyZoom

//// the following effects will use IE's exclusive "filter" function ////
// Begin of CAgencyAlpha definition
function CAgencyAlpha( element, settings, bIsIn )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;
	this.bIsIn = bIsIn;

	// to set the default value
	this.startOpacity = (this.bIsIn) ? 0 : 100;
	this.endOpacity = (this.bIsIn) ? 100 : 0;
	
	this.duration = 1000; // default
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "speed" : this.duration = 100000/arrOneSet[1]; break;
		}
	}
	
	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyAlpha.prototype.PrepareEffect = function()
{// to set the visual filter function
	// the visual filter ONLY work when set by "Width and Height" or
	// absolute position for DIV, SPAN and normal tag ( such as p )
	// but, "absolute" cause the following elements overlap, so:
	CCSSP.PrepareFilter( this.ele );
	CCSSP.ShowObject(this.ele, !this.bIsIn );
}

CAgencyAlpha.prototype.UpdateEffect = function()
{// to set the visual filter function
	if( this.timer == null )
		this.ResetParameters();
	if( typeof(this.ele.filters.alpha) != "object" )
	{
		this.EndEffect();
		return;
	}

	var percent = ((new Date()).getTime() - this.startTime)/this.duration;
	if( percent >= 1.0 )
		this.EndEffect();
	else if( typeof(this.ele.filters.alpha) == "object" )
	{
		this.ele.filters.alpha.opacity = this.startOpacity*(1.0-percent) + this.endOpacity*percent;
		if( this.timer == null )
			this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 20 );
	}
}

CAgencyAlpha.prototype.EndEffect = function()
{// to remove the visual filter function
	clearInterval( this.timer );
	this.timer = null;
	this.ele.style.filter = "";
	CCSSP.ShowObject(this.ele, this.bIsIn );
}

CAgencyAlpha.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	CCSSP.ShowObject(this.ele, true );
	this.ele.style.filter = "alpha(opacity=" + this.startOpacity + ")";
	this.startTime = (new Date()).getTime();
}
// End of the CAgencyAlpha definition

// Begin of CAgencyWave definition
function CAgencyWave( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	this.duration = 0; // default
	this.strength = 10;
	this.freq = 1;
	this.lightstrength = 1;
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "duration" : this.duration = 100000/arrOneSet[1]; break;
		case "strength" : this.strength = arrOneSet[1]; break;
		case "freq" : this.freq = arrOneSet[1]; break;
		case "lightstrength" : this.lightstrength = arrOneSet[1]; break;
		}
	}

	this.timer = null;
	this.aniIndex = CEngine.arrAnimation.length;
	CEngine.arrAnimation[this.aniIndex] = this;
}

CAgencyWave.prototype.PrepareEffect = function()
{// to set the visual filter function
	CCSSP.PrepareFilter(this.ele);

	CCSSP.ShowObject(this.ele, true );
}

CAgencyWave.prototype.UpdateEffect = function()
{// to set the visual filter function
	if( this.timer == null )
		this.ResetParameters();
	if( typeof(this.ele.filters.wave) != "object" )
	{
		this.EndEffect();
		return;
	}

	if( this.duration > 0 )
	{
		var percent = ((new Date()).getTime() - this.startTime)/this.duration;
		if( percent >= 1.0 )
		{
			this.EndEffect();
			return;
		}
	}
	
	this.ele.filters.wave.phase += 5;
	this.ele.filters.wave.phase %= 100;
	if( this.timer == null )
		this.timer = setInterval("CEngine.PerformAnimation(" + this.aniIndex + ")", 50 );
}

CAgencyWave.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
	clearInterval( this.timer );
	this.timer = null;
}

CAgencyWave.prototype.ResetParameters = function()
{
	this.PrepareEffect();
	this.ele.style.filter = "wave(strength=" + this.strength + ",freq=" + 
	 this.freq +", lightstrength=" + this.lightstrength +",phase=0);";
	this.startTime = (new Date()).getTime();
}
// End of the CAgencyWave definition

// Begin of CAgencyGlow definition
function CAgencyGlow( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.glowColor = "green";
	this.glowStrength = "3";
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "color" : this.glowColor = arrOneSet[1]; break;
		case "strength" : this.glowStrength = arrOneSet[1]; break;
		}
	}
}

CAgencyGlow.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject(this.ele, true );
	if( this.ele.style.backgroundColor != "" )
	{//style.backgroundColor somehow stop the visual filter
		this.ele.intactBackgroundColor = this.ele.style.backgroundColor;
		this.ele.style.backgroundColor = "";
	}
}

CAgencyGlow.prototype.UpdateEffect = function()
{// to set the visual filter function
	this.PrepareEffect();
	this.ele.style.filter = "glow(Color=" + this.glowColor + ", Strength=" + 
		this.glowStrength + ", enabled=true" +")";
}

CAgencyGlow.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
	if( typeof(this.ele.intactBackgroundColor) != "undefined" )
		this.ele.style.backgroundColor = this.ele.intactBackgroundColor;
}
// End of the CAgencyGlow definition

// Begin of CAgencyDropShadow definition
function CAgencyDropShadow( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.shadowColor = "black"; 
	this.shadowOffx = "1";
	this.shadowOffy = "1";
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "color" : this.shadowColor = arrOneSet[1]; break;
		case "offx" : this.shadowOffx = arrOneSet[1]; break;
		case "offy" : this.shadowOffy = arrOneSet[1]; break;
		}
	}
}

CAgencyDropShadow.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject(this.ele, true );
	
	if( this.ele.style.backgroundColor != "" )
	{//style.backgroundColor somehow stop the visual filter
		this.ele.intactBackgroundColor = this.ele.style.backgroundColor;
		this.ele.style.backgroundColor = "";
	}
}

CAgencyDropShadow.prototype.UpdateEffect = function()
{// to set the visual filter function
	this.PrepareEffect();
	this.ele.style.filter = "dropshadow(color=" + this.shadowColor + ", offx=" + 
		this.shadowOffx + ", offy=" + this.shadowOffy + ")";
}

CAgencyDropShadow.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
	if( typeof(this.ele.intactBackgroundColor) != "undefined" )
		this.ele.style.backgroundColor = this.ele.intactBackgroundColor;
}
// End of the CAgencyDropShadow definition

// Begin of CAgencyRevealTrans definition
function CAgencyRevealTrans( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.duration = 1.0; //The value is specified in seconds.milliseconds format (0.0000).
	this.transition = 0;
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "type" : this.transition = arrOneSet[1]; break;
		case "duration" : this.duration = 100/arrOneSet[1];	break;
		}
	}
}

CAgencyRevealTrans.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject( this.ele, false);
}

CAgencyRevealTrans.prototype.UpdateEffect = function()
{// to set the visual filter function
	if( typeof( this.ele.filters.RevealTrans ) == "object" )
	{
		if( this.ele.filters.RevealTrans.status == 2 )
			this.ele.filters.RevealTrans.stop();  
	}

	this.PrepareEffect();
	
	this.ele.style.filter = "RevealTrans(duration=" + this.duration + 
		", transition=" + this.transition + ")";
	
    if( typeof( this.ele.filters.RevealTrans ) == "object" )
    {
		this.ele.filters.RevealTrans.apply();
		CCSSP.ShowObject( this.ele, true);
		this.ele.filters.RevealTrans.play();  
	}
	else
		CCSSP.ShowObject( this.ele, true);
}

CAgencyRevealTrans.prototype.EndEffect = function()
{
    if( typeof( this.ele.filters.RevealTrans ) == "object" )
		this.ele.filters.RevealTrans.stop();  
	this.ele.style.filter = "";
}
// End of the CAgencyRevealTrans definition

// Begin of CAgencyBlur definition
function CAgencyBlur( element, settings )
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.strength = "5";
	this.direction = "90";
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "strength" : this.strength = arrOneSet[1]; break;
		case "direction" : this.direction = arrOneSet[1]; break;
		}
	}
}

CAgencyBlur.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject(this.ele, true );
}

CAgencyBlur.prototype.UpdateEffect = function()
{// to set the visual filter function
	CCSSP.PrepareFilter(this.ele);
	this.ele.style.filter = "blur(strength=" + this.strength + 
		", direction=" + this.direction + ")";
}

CAgencyBlur.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
}
// End of the CAgencyBlur definition

// Begin of CAgencyChangeFilter definition
function CAgencyChangeFilter( element, settings ) // flipH, flipV, invert, grey,
{// because of "visual filter" style, this won't work in Navigator
	this.ele = element;

	// to set the default value
	this.filterFunction = settings;
}

CAgencyChangeFilter.prototype.PrepareEffect = function()
{
	CCSSP.PrepareFilter(this.ele);
	CCSSP.ShowObject(this.ele, true );
}

CAgencyChangeFilter.prototype.UpdateEffect = function()
{// to set the visual filter function
	CCSSP.PrepareFilter(this.ele);
	this.ele.style.filter = this.filterFunction;
}

CAgencyChangeFilter.prototype.EndEffect = function()
{// to remove the visual filter function
	this.ele.style.filter = "";
}
// End of the CAgencyChangeFilter definition

// The effects below change the style on the fly, so they won't work in Navigator

// Begin of CAgencyFontChange definition, 
function CAgencyFontChange( element, settings )
{//this class can be replace by CAgencyChangeStyle,provided the "settings" is standard CSS string.
	this.ele = element;
	
	// to retrieve the original font style
	this.RetrieveOldFont( this.ele );
	
	// to set the default font to change
	this.newfontFamily = this.ele.oldFontFamily;
	this.newfColor = this.ele.oldColor;
	this.newtextDecoration = this.ele.oldTextDecoration;
	this.newfontWeight = this.ele.oldFontWeight;
	this.newfontStyle = this.ele.oldFontStyle;
	this.newfontSize = this.ele.oldFontSize;
	this.newBackgroundColor = this.ele.oldBackgroundColor;
	
	var arrAllSet = settings.split(",");
	for( var i = 0; i < arrAllSet.length; i ++ )
	{// to retrieve the setting
		arrAllSet[i] = CCSSP.TrimSpace(arrAllSet[i]);
		var arrOneSet = arrAllSet[i].split("=");
		for( var j = 0; j < arrOneSet.length; j++ )
			arrOneSet[j] = CCSSP.TrimSpace(arrOneSet[j]);
		switch( arrOneSet[0] )
		{
		case "font-family" : this.newfontFamily = arrOneSet[1]; break;
		case "color" : this.newfColor = arrOneSet[1]; break;
		case "underline" : this.newtextDecoration = (arrOneSet[1]=="on")? "underline" : "none"; break;
		case "bold" : this.newfontWeight = (arrOneSet[1]=="on")? "bold" : "normal"; break;
		case "italic" : this.newfontStyle = (arrOneSet[1]=="on")? "italic" : "normal"; break;
		case "size" : this.newfontSize = arrOneSet[1]; break;
		case "background-color" : this.newBackgroundColor = arrOneSet[1]; break;
		}
	}
}

CAgencyFontChange.prototype.RetrieveOldFont = function(objChild)
{
	if( typeof(objChild.oldFontFamily) == "undefined" )
		objChild.oldFontFamily = objChild.style.fontFamily;
	if( typeof(objChild.oldColor) == "undefined" )
		objChild.oldColor = objChild.style.color;
	if( typeof(objChild.oldTextDecoration) == "undefined" )
		objChild.oldTextDecoration = objChild.style.textDecoration;
	if( typeof(objChild.oldFontWeight) == "undefined" )
		objChild.oldFontWeight = objChild.style.fontWeight;
	if( typeof(objChild.oldFontStyle) == "undefined" )
		objChild.oldFontStyle = objChild.style.fontStyle;
	if( typeof(objChild.oldFontSize) == "undefined" )
		objChild.oldFontSize = objChild.style.fontSize;
	if( typeof(objChild.oldBackgroundColor) == "undefined" )
		objChild.oldBackgroundColor = objChild.style.backgroundColor;
}

CAgencyFontChange.prototype.PrepareEffect = function()
{
	// as for expanding text, the child is created after the constructor called
	for(var index = 0; index < this.ele.all.length; index++)
		this.RetrieveOldFont(this.ele.all[index]);
	CCSSP.ShowObject(this.ele, true );
}

CAgencyFontChange.prototype.UpdateEffect = function()
{// to change the font
	this.PrepareEffect();
	this.UpdateEffectAllChildren( this.ele );
	for( var index = 0; index < this.ele.all.length; index++)
		this.UpdateEffectAllChildren(this.ele.all[index]);
}

CAgencyFontChange.prototype.UpdateEffectAllChildren = function(objChild)
{
	objChild.style.fontFamily = this.newfontFamily;
	objChild.style.color = this.newfColor;
	objChild.style.textDecoration = this.newtextDecoration;
	objChild.style.fontWeight = this.newfontWeight;
	objChild.style.fontStyle = this.newfontStyle;
	objChild.style.fontSize = this.newfontSize;
	objChild.style.backgroundColor = this.newBackgroundColor;
}

CAgencyFontChange.prototype.EndEffect = function()
{// to reinstate the original font style
	this.EndEffectAllChildren( this.ele );
	for( var index = 0; index < this.ele.all.length; index++)
		this.EndEffectAllChildren(this.ele.all[index]);
}

CAgencyFontChange.prototype.EndEffectAllChildren = function( objChild )
{
	if( typeof(objChild.oldFontFamily) != "undefined" )
		objChild.style.fontFamily = objChild.oldFontFamily;
	if( typeof(objChild.oldColor) != "undefined" )
		objChild.style.color = objChild.oldColor;
	if( typeof(objChild.oldFontWeight) != "undefined" )
		objChild.style.fontWeight = objChild.oldFontWeight;
	if( typeof(objChild.oldFontStyle) != "undefined" )
		objChild.style.fontStyle = objChild.oldFontStyle;
	if( typeof(objChild.oldFontSize) != "undefined" )
		objChild.style.fontSize = objChild.oldFontSize;
	if( typeof(objChild.oldTextDecoration) != "undefined" )
		objChild.style.textDecoration = objChild.oldTextDecoration;
	if( typeof(objChild.oldBackgroundColor) != "undefined" )
		objChild.style.backgroundColor = objChild.oldBackgroundColor;
}
// End of the CAgencyFontChange definition

// Begin of the CAgencyChangeStyle definition
function CAgencyChangeStyle( element, settings )
{//this class can be replace by CAgencyChangeStyle,provided the "settings" is standard CSS string.
	this.ele = element;
	
	// to retrieve the original style
	this.oldstyle = this.ele.style.cssText;
	
	// to set the default style
	this.newStyle = this.oldstyle;
	
	if( typeof(settings) == "string" && settings.length > 1 )
		this.newStyle = this.oldstyle + " " + settings;
}

CAgencyChangeStyle.prototype.PrepareEffect = function()
{
	CCSSP.ShowObject(this.ele, true );
}

CAgencyChangeStyle.prototype.UpdateEffect = function()
{// to change the style
	this.ele.style.cssText = this.newStyle;
}

CAgencyChangeStyle.prototype.EndEffect = function()
{// to reinstate the original style
	this.ele.style.cssText = this.oldStyle;
}
// End of the CAgencyChangeStyle definition

//End the definition of CAgencyXXXX classes

//Begin to collaborate with other event handler settings 
CCSSP.RegisterEventHandler( window, "onload", "CEngine.OnPageLoad();BSSCOnLoad();kadovInitTriggersInHead();");
CCSSP.RegisterEventHandler( document, "onclick", "CEngine.OnPageClick();BSSCOnClick();");
CCSSP.RegisterEventHandler( document, "onmouseover", "CEngine.OnMouseOver();BSSCOnMouseOver();" );
CCSSP.RegisterEventHandler( document, "onmouseout", "CEngine.OnMouseOver();BSSCOnMouseOut();" );
CCSSP.RegisterEventHandler( window, "onunload", "BSSCOnUnload();");
//End to collaborate with other event handler settings


/// Section End  - CCSSP DHTM 2 (JavaScript 1.2)

//// Segment End -- (JavaScript 1.2)
